//
//  CMS_Forms.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 06/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*
 
 CMS_Forms (non-static, each object will track display coordinates as new fields are added, hidden parameters, the intro text, the target URL, the button name, and references between UI inputs and parameter names)
 
 form_input_field_spacer(string heading, string text) - put a heading into the form
 void form_input_hidden(string paramName, string paramValue) -
 object form_input_integer(string prettyName, string description, string paramName, string defaultValue, bool isRequired) - defaultValue is either blank or a numeric string
 object form_input_float(string prettyName, string description, string paramName, string defaultValue, bool isRequired) - defaultValue is either blank or a numeric string
 object form_input_line(string prettyName, string description, string paramName, string defaultValue, bool isRequired) - inputs a single line of text
 object form_input_list(string prettyName, string description, string paramName, map options, string defaultValue, bool isRequired) - options is a map between actual inputted values and the displayed labels
 object form_input_text(string prettyName, string description, string paramName, string defaultValue, bool isRequired) - inputs multiple lines of text
 object form_input_tick(string prettyName, string description, string paramName, bool defaultValue)
 object form_input_uploaded_picture(string prettyName, string description, string paramName, bool isRequired)
 object form_input_date(string prettyName, string description, string paramName, bool isRequired, string defaultValue, bool includeTimeChoice) - defaultValue is either blank or a numeric string (unix timestamp)
 int get_input_date(string paramName) - get unix timestamp from a named date input
 string post_param_string(string paramName) - get value of a named input
 int post_param_integer(string paramName) - get value of a named input, as an integer
 void set_intro_text(string text)
 void set_url(string url)
 void set_button(string name, callback callback)
 void do_http_post_request(callback callback) - converts form into an HTTP request, and sends the HTTP response to the given callback; should automatically add and remove a progress spinner and lock out the UI temporarily
 
 */

/*
 Form field dictionary prototype
 
 @{
 @"field_Type" : @"<field type from fieldType enum>",
 @"field_Name" : @"pretty name for the field",
 @"field_Description" : @"description for the field",
 @"field_Param_Name" : @"form field parameter name",
 @"field_Values" : @"values that needs to be preloaded - like options for list",
 @"field_Default_Value" : @"default value for field",
 @"field_is_Mandatory" : @"field is mandatory or not",
 @"field_Extra_Params" : @"A dictionary for storing any extra values",
 @"field_Object" : @"an object that represents the object and any subobjects if required"
 }
 */

import UIKit
import Foundation

enum fieldType : Int {
    case Input_Field_Hidden = 0
    case Input_Field_Spacer = 1
    case Input_Field_Integer = 2
    case Input_Field_Float = 3
    case Input_Field_Line = 4
    case Input_Field_List = 5
    case Input_Field_Text = 6
    case Input_Field_Tick = 7
    case Input_Field_Upload_Picture = 8
    case Input_Field_Date = 9
}

var formY = 0

let formWidth = self.frame.size.width
let formFieldHeight = 70.0
let formRect = CGRectMake(0, formY, formWidth, formFieldHeight)
let formFieldViewTag = 111
let kOFFSET_FOR_KEYBOARD = 80.0

class CMS_Forms: UIView, UITextFieldDelegate {
    func form_input_field_spacer_withHeading(heading: String, withText text: String) {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblHeading = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblHeading.text = heading
        var lblText = UILabel(frame: CGRectMake(10, 35, fieldView.frame.size.width - 10, 30))
        lblText.text = text
        fieldView.addSubview(lblHeading)
        fieldView.addSubview(lblText)
        var field = ["field_Type": "\(Input_Field_Spacer)", "field_Name": heading, "field_Description": text, "field_Param_Name": "form field parameter name", "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": "default value for field", "field_is_Mandatory": "field is mandatory or not", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
    }

    func form_input_hidden_withParamName(paramName: String, withParamValue paramValue: String) {
        var field = ["field_Type": "\(Input_Field_Hidden)", "field_Name": "pretty name for the field", "field_Description": "description for the field", "field_Param_Name": paramName, "field_Values": paramValue, "field_Default_Value": "default value for field", "field_is_Mandatory": "field is mandatory or not", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": "an object that represents the object and any subobjects if required"]
        formFields.append(field)
    }

    func form_input_integer_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = NumberInput(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30), defaultValue: defaultValue, placeHolder: prettyName, supportFloat: false)
        txtInput.tag = 113
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Integer)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_float_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = NumberInput(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30), defaultValue: defaultValue, placeHolder: prettyName, supportFloat: true)
        txtInput.tag = 114
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Float)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_line_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = UITextField(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30))
        txtInput.keyboardType = .Default
        txtInput.placeholder = prettyName
        txtInput.tag = formFieldViewTag
        txtInput.delegate = self
        txtInput.borderStyle = .RoundedRect
        txtInput.returnKeyType = UIReturnKeyDone
        txtInput.clearButtonMode = .WhileEditing
        txtInput.contentVerticalAlignment = .Center
        if defaultValue != nil && !(defaultValue == "") {
            txtInput.text = defaultValue
        }
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Line)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_password_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = UITextField(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30))
        txtInput.keyboardType = .Default
        txtInput.placeholder = prettyName
        txtInput.tag = formFieldViewTag
        txtInput.delegate = self
        txtInput.secureTextEntry = true
        txtInput.borderStyle = .RoundedRect
        txtInput.returnKeyType = UIReturnKeyDone
        txtInput.clearButtonMode = .WhileEditing
        txtInput.contentVerticalAlignment = .Center
        if defaultValue != nil && !(defaultValue == "") {
            txtInput.text = defaultValue
        }
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Line)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_list_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withOptions options: [NSObject : AnyObject], withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = ComboBox(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30))
        txtInput.options = options.allValues()
        txtInput.keys = options.allKeys()
        var valueIndex = 0
        for option: String in options.allKeys() {
            if (option == defaultValue) {
                valueIndex = Int(options.allKeys().indexOf(option))
            }
        }
        txtInput.defaultValue = valueIndex
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_List)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": "\(valueIndex)", "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_text_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        var textFieldRect = formRect
        textFieldRect.size.height += 60
        fieldView.frame = textFieldRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var textView = UITextView(frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 90))
        textView.backgroundColor = UIColor.clearColor()
        textView.keyboardType = .NumbersAndPunctuation
        textView.layer.borderColor = UIColor.grayColor().colorWithAlphaComponent(0.5).CGColor
        textView.layer.borderWidth = 1.0
        textView.layer.cornerRadius = 5
        textView.clipsToBounds = true
        textView.scrollEnabled = true
        textView.editable = true
        textView.tag = formFieldViewTag
        if defaultValue != nil && !(defaultValue == "") {
            textView.text = defaultValue
        }
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(textView)
        var field = ["field_Type": "\(Input_Field_Text)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 150
        self.addFormHeight(150)
        return fieldView
    }

    func form_input_tick_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, withDefaultValue defaultValue: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var name = UILabel(frame: CGRectMake(10, 35, fieldView.frame.size.width - 70, 31))
        name.text = prettyName
        var txtInput = UISwitch(frame: CGRectMake(name.frame.origin.x + name.frame.size.width + 5, 35, 51, 31))
        txtInput.on = defaultValue
        txtInput.tag = formFieldViewTag
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(name)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Tick)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": Int(defaultValue), "field_is_Mandatory": "field is mandatory or not", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func form_input_uploaded_picture_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, isRequired: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = CGRectMake(0, formY, formWidth, formFieldHeight + 70)
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var photoView = PhotoUpload(frame: CGRectMake(10, 35, 100, 100))
        photoView.image = UIImage(named: "no_image.png")!
        photoView.tag = formFieldViewTag
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(photoView)
        var field = ["field_Type": "\(Input_Field_Upload_Picture)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": "default value for field", "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += (90 + 70)
        self.addFormHeight(90 + 70)
        return fieldView
    }

    func form_input_date_withPrettyName(prettyName: String, withDescription description: String, withParamName paramName: String, isRequired: Bool, withDefaultValue defaultValue: String, includeTimeChoice: Bool) -> AnyObject {
        var fieldView = UIView()
        fieldView.frame = formRect
        var lblDescription = UILabel(frame: CGRectMake(10, 0, fieldView.frame.size.width - 10, 30))
        lblDescription.text = description
        var txtInput = DatePicker.initDatePickerWithTime(includeTimeChoice, frame: CGRectMake(10, 35, fieldView.frame.size.width - 20, 30))
        txtInput.tag = 112
        fieldView.addSubview(lblDescription)
        fieldView.addSubview(txtInput)
        var field = ["field_Type": "\(Input_Field_Date)", "field_Name": prettyName, "field_Description": description, "field_Param_Name": paramName, "field_Values": "values that needs to be preloaded - like options for list", "field_Default_Value": defaultValue, "field_is_Mandatory": isRequired ? "1" : "0", "field_Extra_Params": "A dictionary for storing any extra values", "field_Object": fieldView]
        formFields.append(field)
        form.addSubview(fieldView)
        formY += 90
        self.addFormHeight(90)
        return fieldView
    }

    func get_input_date(paramName: String) -> Int {
        return CInt(Int(self.get_form_field_value(self.getFormFieldDict(paramName))))
    }

    func post_param_string(paramName: String) -> String {
        return "\(self.get_form_field_value(self.getFormFieldDict(paramName)))"
    }

    func post_param_integer(paramName: String) -> Int {
        return Int(((self.get_form_field_value(self.getFormFieldDict(paramName)) as! String) as NSString ?? "0").intValue)
    }

    func set_intro_text(text: String) {
        introText = String = text
        introLbl.text = introText
    }

    func set_url(url: String) {
        targetUrl = String = url
    }

    func set_button_withName(name: String, preSubmitGuard: Selector, postCallback: Selector, autoSubmit: Bool) {
        submitBtnName = String = name
        submitBtn.setTitle(submitBtnName, forState: .Normal)
        if autoSubmit {
            submitBtn.addTarget(self, action: (self.do_http_post_request), forControlEvents: .TouchUpInside)
        }
        else {
            submitBtn.addTarget(self, action: (self.doValidateForm), forControlEvents: .TouchUpInside)
        }
        preSubmitCallback = preSubmitGuard
        submitCallback = postCallback
    }

    func do_http_post_request() {
    }

    func getFormValues() -> [NSObject : AnyObject] {
        var s = CMS_Arrays.collapse_1d_complexity("field_Type", formFields)
        var paramNames = CMS_Arrays.collapse_1d_complexity("field_Param_Name", formFields)
        var postParams = [NSObject : AnyObject]()
        for i in 0..<formFields.count {
            if CInt(s[i]) == Input_Field_Spacer {

            }
            if CInt(s[i]) != Input_Field_Upload_Picture {
                postParams[paramNames[i]] = self.get_form_field_value(formFields[i])
            }
        }
        return postParams
    }
    weak var delegate: AnyObject?
    var formFields = [AnyObject]()
    //contains all form elements
    var introText = ""
    var targetUrl = ""
    var submitBtnName = ""
    var submitCallback = Selector()
    var preSubmitCallback = Selector()
    var backupFrame = CGRect.zero


    var form: UIView!
    var formContainer: UIScrollView!
    var submitContainer: UIView!
    var introContainer: UIView!
    var submitBtn: UIButton!
    var introLbl: UILabel!

    override init() {
        super.init()
        
        self.initialize()
    
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.initialize()
    
    }

    override func initialize() {
        formY = 0
        formFields = [AnyObject]()
        introText = "Form"
        targetUrl = ""
        submitBtnName = "Submit"
        //creating submit button and it's container view
        do {
            submitContainer = UIView(frame: CGRectMake(0, self.frame.size.height - 70, self.frame.size.width, 70))
            submitBtn = UIButton(type: .RoundedRect)
            submitBtn.setTitle(submitBtnName, forState: .Normal)
            submitBtn.frame = CGRectMake(10, 10, submitContainer.frame.size.width - 20, submitContainer.frame.size.height - 20)
            submitContainer.addSubview(submitBtn)
            self.addSubview(submitContainer)
        }
        //creating introText containter
        do {
            introContainer = UIView(frame: CGRectMake(0, 0, self.frame.size.width, 70))
            introLbl = UILabel(frame: CGRectMake(10, 10, introContainer.frame.size.width - 20, introContainer.frame.size.height - 20))
            introLbl.textAlignment = .Center
            introLbl.text = introText
            introContainer.addSubview(introLbl)
        }
        //creating scrollview and form superview
        do {
            formContainer = UIScrollView(frame: CGRectMake(0, introContainer.frame.size.height, self.frame.size.width, self.frame.size.height - submitContainer.frame.size.height - introContainer.frame.size.height))
            formContainer.clipsToBounds = true
            form = UIView(frame: CGRectMake(0, 0, formContainer.frame.size.width, 0))
            formContainer.contentSize = form.frame.size
            formContainer.addSubview(form)
        }
        self.addSubview(introContainer)
        self.addSubview(formContainer)
        self.addSubview(submitContainer)
        //adding observer for keyboard popup
        do {
            NSNotificationCenter.defaultCenter().addObserver(self, selector: (self.keyboardDidShow), name: UIKeyboardDidShowNotification, object: nil)
            NSNotificationCenter.defaultCenter().addObserver(self, selector: (self.keyboardDidHide), name: UIKeyboardDidHideNotification, object: nil)
        }
        var tap = UITapGestureRecognizer(target: self, action: (self.singleTap))
        tap.numberOfTapsRequired = 1
        tap.numberOfTouchesRequired = 1
        self.addGestureRecognizer(tap)
    }

    func singleTap() {
        self.endEditing(true)
    }

    deinit {
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardDidShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardDidHideNotification, object: nil)
    }

    func doValidateForm() {
        if !self.validateForm() {
            if delegate != nil && preSubmitCallback != nil {
                if delegate!.respondsToSelector(preSubmitCallback) {
                    delegate!.performSelector(preSubmitCallback)
                }
            }
            return
        }
        else {
            if delegate != nil && delegate!.respondsToSelector(submitCallback) {
                delegate!.performSelector(submitCallback)
            }
        }
    }

    func do_http_post_request(callback: Selector) {
        if !self.validateForm() {
            if delegate != nil && preSubmitCallback != nil {
                if delegate!.respondsToSelector(preSubmitCallback) {
                    delegate!.performSelector(preSubmitCallback)
                }
            }
            return
        }
        var s = CMS_Arrays.collapse_1d_complexity("field_Type", formFields)
        var paramNames = CMS_Arrays.collapse_1d_complexity("field_Param_Name", formFields)
        var multiPartDataParams = [AnyObject]()
        for i in 0..<s.count {
            if CInt(s[i]) == Input_Field_Upload_Picture {
                multiPartDataParams.append("\(i)")
            }
        }
        var postParams = [NSObject : AnyObject]()
        for i in 0..<formFields.count {
            if CInt(s[i]) == Input_Field_Spacer {

            }
            if CInt(s[i]) != Input_Field_Upload_Picture {
                postParams[paramNames[i]] = self.get_form_field_value(formFields[i])
            }
        }
        MBProgressHUD.showGlobalProgressHUD()
        var networkManager = CMSNetworkManager.sharedManager()
        networkManager.POST(targetUrl, parameters: postParams, constructingBodyWithBlock: {(formData: AFMultipartFormData) -> Void in
            for i: String in multiPartDataParams {
                var index = CInt(i)
                formData.appendPartWithFormData((self.get_form_field_value(formFields[index]) as! NSData), name: paramNames[index])
            }
        }, success: {(operation: AFHTTPRequestOperation, responseObject: AnyObject) -> Void in
            print("\(responseObject)")
            if delegate != nil {
                if delegate!.respondsToSelector(submitCallback) {
                    delegate!.performSelector(submitCallback, withObject: responseObject)
                }
                if callback && delegate!.respondsToSelector(callback) {
                    delegate!.performSelector(callback)
                }
            }
            MBProgressHUD.dismissGlobalHUD()
        }, failure: {(operation: AFHTTPRequestOperation, error: NSError) -> Void in
            print("\(error.localizedDescription)")
            MBProgressHUD.dismissGlobalHUD()
        })
    }

    func get_form_field_value(formField: [NSObject : AnyObject]) -> NSObject {
        var fieldType = Int(((formField.valueForKey("field_Type") as! String) as NSString ?? "0").intValue)
        var value: NSObject?
        if fieldType == Input_Field_Hidden {
            value = (formField["field_Values"] as! String)
        }
        else if fieldType == Input_Field_Upload_Picture {
            value = UIImageJPEGRepresentation((((formField["field_Object"] as! String) as! UIView).viewWithTag(formFieldViewTag)! as! UIImageView).image!, 0.6)
        }
        else if fieldType == Input_Field_Date {
            value = "\((((formField["field_Object"] as! String) as! UIView).viewWithTag(112)! as! DatePicker).timestamp)"
        }
        else if fieldType == Input_Field_Tick {
            value = (((formField["field_Object"] as! String) as! UIView).viewWithTag(formFieldViewTag)! as! UISwitch).isOn() ? "YES" : "NO"
        }
        else if fieldType == Input_Field_List {
            value = (((formField["field_Object"] as! String) as! UIView).viewWithTag(formFieldViewTag)! as! ComboBox).value
        }
        else {
            value = (((formField["field_Object"] as! String) as! UIView).viewWithTag(formFieldViewTag)! as! UITextField).text
        }

        return value
    }

    func getFormFieldDict(paramName: String) -> [NSObject : AnyObject] {
        for dict: [NSObject : AnyObject] in formFields {
            if ((dict["field_Param_Name"] as! String) == paramName) {
                return dict
            }
        }
        return nil
    }

    func validateForm() -> Bool {
        var pass = true
        for formField: [NSObject : AnyObject] in formFields {
            if Int(((formField["field_is_Mandatory"] as! String) as NSString ?? "0").intValue) == 0 {

            }
            switch Int(((formField["field_Type"] as! String) as NSString ?? "0").intValue) {
                case Input_Field_Float, Input_Field_Integer, Input_Field_Line, Input_Field_Text, Input_Field_List:
                                        var value = (self.get_form_field_value(formField) as! String)
                    if value == nil || (value == "") {
                        var formFieldView = (formField["field_Object"] as! String)
                        formFieldView.backgroundColor = UIColor.redColor()
                        formFieldView.alpha = 0.3
                        pass = false
                    }
                    else {
                        var formFieldView = (formField["field_Object"] as! String)
                        formFieldView.backgroundColor = UIColor.clearColor()
                        formFieldView.alpha = 1
                    }

                case Input_Field_Upload_Picture:
                    break
                case Input_Field_Date:
                                        var value = (self.get_form_field_value(formField) as! String)
                    if value == nil || (value == "0") {
                        var formFieldView = (formField["field_Object"] as! String)
                        formFieldView.backgroundColor = UIColor.redColor()
                        formFieldView.alpha = 0.3
                        pass = false
                    }
                    else {
                        var formFieldView = (formField["field_Object"] as! String)
                        formFieldView.backgroundColor = UIColor.clearColor()
                        formFieldView.alpha = 1
                    }

                default:
                    break
            }
        }
        return pass
    }

    func addFormHeight(height: Float) {
        var currentFrame = form.frame
        form.frame = CGRectMake(currentFrame.origin.x, currentFrame.origin.y, currentFrame.size.width, currentFrame.size.height + height)
        formContainer.contentSize = form.frame.size
    }
// MARK: UITextFieldDelegate

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
// MARK: View anmations and listeners for keyboard show and hide

    func setViewMovedUp(movedUp: Bool) {
        // ios9 method gets entered when the view is attached
        if !movedUp && backupFrame.size.height == 0 && backupFrame.size.width == 0 {
            return
        }
        // backup original frame instead of referring origin with keyboard frame
        if movedUp {
            backupFrame = self.frame
        }
        UIView.beginAnimations(nil, context: nil)
        UIView.animationDuration = 0.3
            // if you want to slide up the view
        var rect = self.frame
        if movedUp {
            // 1. move the view's origin up so that the text field that will be hidden come above the keyboard
            // 2. increase the size of the view so that the area behind the keyboard is covered up.
            rect.origin.y -= kOFFSET_FOR_KEYBOARD
            rect.size.height += kOFFSET_FOR_KEYBOARD
            self.backgroundColor = UIColor.yellowColor()
        }
        else {
            // revert back to the normal state.
            rect.origin.y = backupFrame.origin.y
            rect.size.height -= kOFFSET_FOR_KEYBOARD
            self.backgroundColor = UIColor.redColor()
        }
        self.frame = rect
        UIView.commitAnimations()
    }

    func keyboardDidShow() {
        self.viewMovedUp = true
    }

    func keyboardDidHide() {
        self.viewMovedUp = false
    }
}